#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  White and green rugMod01.fsh  by   Jarble  
//https://www.shadertoy.com/view/XcBfDV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 triangle_wave(vec2 a){
    vec2 a2 =
        vec2(1.,0.5)
    ,
    a1 = a+a2;
    return abs(fract((a1)*(a2.x+a2.y))-.5);
}

vec3 fractal(vec2 uv){
    vec3 col = vec3(0.);
    float scale = 1.5;
    vec2 t2 = vec2(0.);
    vec3 col1 = col;
    float c1=0.;
    for(int k = 0; k < 12; k++){
    
        //uv.x += sign(uv.y-.5)/1.5/3.;
        
        //uv = -(uv+t2)/scale;
        
        uv = (.5-(fract(vec2(uv+vec2(.5,1.5))*scale)-.5))/scale;

        t2 =
            -triangle_wave(uv-.5)
            //-triangle_wave(uv-.5) - sign(t2.y-.25)
            //triangle_wave(uv+.5)
        ;
        uv =
            //t2-triangle_wave(uv.yx)+fract(t2/2.)
            
            //looks better with more iterations
            //t2-triangle_wave(uv.yx+1.)
            t2-triangle_wave(uv.yx)
        ;
        
        c1 =
            //max(abs(uv.y-uv.x*sign(uv.x-uv.y))/2.,c1)
            max(abs(uv.y-uv.x)/2.,c1)
        ;
        c1 =
            1.-abs(2.*c1-1.)
            
            //more colorful
            //abs(2.*c1-1.)
            
            //Spooky!
            //max(abs(2.*c1-2.),c1/4.)/2.
        ;
        col.x =
             //col.x
            
            //blue and white
            //c1
            
            //red and blue and white
            //max(1.-abs(2.*c1-1.),c1/4.)

            
            //more colorful
            //max(length(uv-t2-c1)/3.,1.-col.x)
            
            //blue and green
            max(length(uv-c1)/3.,col.x)
            //length(uv-c1)/3.
           
            //purple
            //2. - max((abs(uv.y-uv.x))/3.,col.x)
           
            //black and white
            //col.x
        ;
        col =
            abs(col-(1.-(c1*col.x)));
        col1 =
            abs(col1*c1-col-1.).yzx
            //abs(col1*c1-col*sign(t2.y-t2.x)-1.).yzx
        ;
        //uv.x += sign(uv.y-.5)/2.;
        //uv.y += sign(uv.x-.5)/2.;
    }
    return col1;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = vec4(0.0);
    float t1 = 8.*4.;
    
    vec2 uv = (fragCoord)/iResolution.y/t1/2.0;
    uv.xy += iTime/t1/12.;
    if(iMouse.z>.5)
    uv = uv.xy + iMouse.xy / iResolution.xy/t1;
    vec3 col1 = fractal(uv);
    fragColor = vec4(col1/2.,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

